/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.jdbc;

import com.oceanbase.jdbc.CallParameter;
import com.oceanbase.jdbc.OceanBaseConnection;
import com.oceanbase.jdbc.internal.com.read.resultset.ColumnDefinition;
import com.oceanbase.jdbc.internal.util.ParsedCallParameters;
import com.oceanbase.jdbc.internal.util.Utils;
import com.oceanbase.jdbc.internal.util.dao.ServerPrepareResult;
import java.sql.ParameterMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CallableParameterMetaData
implements ParameterMetaData {
    private static final Pattern PARAMETER_PATTERN = Pattern.compile("\\s*(IN\\s+|OUT\\s+|INOUT\\s+)?(\\`[\\w\\d]+\\`)\\s+(UNSIGNED\\s+)?(\\w+)\\s*(\\([\\d,]+\\))?\\s*", 2);
    private static final Pattern RETURN_PATTERN = Pattern.compile("\\s*(UNSIGNED\\s+)?(\\w+)\\s*(\\([\\d,]+\\))?\\s*(CHARSET\\s+)?(\\w+)?\\s*", 2);
    protected final OceanBaseConnection con;
    protected final String name;
    protected List<CallParameter> params = null;
    protected Map<String, CallParameter> mapNameToParamter;
    protected String obOraclePackageName;
    protected String obOracleSchema;
    protected String database;
    protected boolean valid;
    protected boolean isFunction;
    protected String query;

    public String getProName() {
        return this.name;
    }

    public String getDatabase() {
        return this.database;
    }

    public CallableParameterMetaData(OceanBaseConnection con, String database, String name, boolean isFunction) {
        this.con = con;
        if (database != null) {
            String tmp = database.replace("`", "");
            if (this.con.getProtocol().isOracleMode()) {
                if (tmp.equals(this.con.getProtocol().getDatabase())) {
                    this.database = tmp;
                    this.obOracleSchema = tmp;
                } else if (tmp.contains(".")) {
                    String[] databaseAndPackage = tmp.split("\\.");
                    if (databaseAndPackage.length == 2) {
                        this.obOraclePackageName = databaseAndPackage[1].startsWith("\"") && databaseAndPackage[1].endsWith("\"") ? databaseAndPackage[1].replace("\"", "") : databaseAndPackage[1].toUpperCase(Locale.ROOT);
                        this.obOracleSchema = databaseAndPackage[0].startsWith("\"") && databaseAndPackage[0].endsWith("\"") ? databaseAndPackage[0].replace("\"", "") : databaseAndPackage[0].toUpperCase(Locale.ROOT);
                        this.database = databaseAndPackage[0];
                    }
                } else {
                    if (tmp.startsWith("\"") && tmp.startsWith("\"")) {
                        if (tmp.replace("\"", "").equals(this.con.getProtocol().getDatabase())) {
                            this.obOracleSchema = tmp.replace("\"", "");
                            this.obOraclePackageName = null;
                        } else {
                            this.obOracleSchema = null;
                            this.obOraclePackageName = tmp.replace("\"", "");
                        }
                    } else if (tmp.equals(this.con.getProtocol().getDatabase()) || tmp.toUpperCase(Locale.ROOT).equals(this.con.getProtocol().getDatabase())) {
                        this.obOraclePackageName = null;
                        this.obOracleSchema = tmp.toUpperCase(Locale.ROOT);
                    } else {
                        this.obOraclePackageName = tmp.toUpperCase(Locale.ROOT);
                        this.obOracleSchema = null;
                    }
                    this.database = this.con.getProtocol().getDatabase();
                }
            } else {
                this.database = database;
            }
        } else {
            this.database = null;
        }
        this.name = name.startsWith("\"") && name.endsWith("\"") ? name.replace("`", "").replace("\"", "") : name.replace("`", "").toUpperCase(Locale.ROOT);
        this.isFunction = isFunction;
    }

    public void readMetadataFromDbIfRequired() throws SQLException {
        if (this.valid) {
            return;
        }
        this.readMetadata();
        this.valid = true;
    }

    public void generateMetadataFromPrepareResultSet(ServerPrepareResult serverPrepareResult) throws SQLException {
        if (this.valid) {
            return;
        }
        this.params = new ArrayList<CallParameter>();
        ColumnDefinition[] parameters = serverPrepareResult.getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            CallParameter callParameter = new CallParameter();
            callParameter.setName("");
            callParameter.setOutput(false);
            callParameter.setInput(false);
            this.params.add(callParameter);
        }
        this.valid = false;
    }

    public void readMetadataFromDbIfRequired(String query, String arguments, Boolean isObFunction) throws SQLException {
        if (this.valid) {
            return;
        }
        this.query = query;
        this.readMetadata();
        this.resetParams(arguments, isObFunction);
    }

    void resetParams(String arguments, boolean isObFunction) {
        int parameterCount = this.params.size();
        ArrayList<CallParameter> currentParams = new ArrayList<CallParameter>(parameterCount);
        int[] placeholderToParameterIndexMap = new int[parameterCount];
        for (int i = 0; i < parameterCount; ++i) {
            placeholderToParameterIndexMap[i] = -1;
        }
        List<ParsedCallParameters> paramList = new ArrayList<ParsedCallParameters>();
        if (arguments != null) {
            arguments = Utils.trimSQLString(arguments, false, true, false);
            paramList = Utils.argumentsSplit(arguments, ",", "'\"", "'\"");
        }
        int placeholderCount = 0;
        if (isObFunction) {
            paramList.add(0, new ParsedCallParameters(true, "?"));
        }
        for (int i = 0; i < paramList.size(); ++i) {
            if (!((ParsedCallParameters)paramList.get(i)).isParam()) continue;
            placeholderToParameterIndexMap[placeholderCount++] = i;
        }
        parameterCount = placeholderCount;
        for (int index = 0; index < this.params.size(); ++index) {
            if (placeholderToParameterIndexMap != null) {
                int localIndex = placeholderToParameterIndexMap[index];
                if (localIndex == -1) continue;
                CallParameter parameter = this.params.get(localIndex);
                currentParams.add(parameter);
                continue;
            }
            CallParameter parameter = this.params.get(index + 1);
            if (parameter.getIndex() == -1) continue;
            currentParams.add(parameter);
        }
        this.params = currentParams;
        this.valid = true;
    }

    private int mapMariaDbTypeToJdbc(String str) {
        switch (str.toUpperCase(Locale.ROOT)) {
            case "BIT": {
                return -7;
            }
            case "TINYINT": {
                return -6;
            }
            case "SMALLINT": {
                return 5;
            }
            case "MEDIUMINT": {
                return 4;
            }
            case "INT": {
                return 4;
            }
            case "INTEGER": {
                return 4;
            }
            case "LONG": {
                return 4;
            }
            case "BIGINT": {
                return -5;
            }
            case "INT24": {
                return 4;
            }
            case "REAL": {
                return 8;
            }
            case "FLOAT": {
                return 6;
            }
            case "DECIMAL": {
                return 3;
            }
            case "NUMERIC": {
                return 2;
            }
            case "DOUBLE": {
                return 8;
            }
            case "CHAR": {
                return 1;
            }
            case "VARCHAR": {
                return 12;
            }
            case "DATE": {
                return 91;
            }
            case "TIME": {
                return 92;
            }
            case "YEAR": {
                return 5;
            }
            case "TIMESTAMP": {
                return 93;
            }
            case "DATETIME": {
                return 93;
            }
            case "TINYBLOB": {
                return -2;
            }
            case "BLOB": {
                return -4;
            }
            case "MEDIUMBLOB": {
                return -4;
            }
            case "LONGBLOB": {
                return -4;
            }
            case "TINYTEXT": {
                return 12;
            }
            case "TEXT": {
                return -1;
            }
            case "MEDIUMTEXT": {
                return -1;
            }
            case "LONGTEXT": {
                return -1;
            }
            case "ENUM": {
                return 12;
            }
            case "SET": {
                return 12;
            }
            case "GEOMETRY": {
                return -4;
            }
            case "VARBINARY": {
                return -3;
            }
        }
        return 1111;
    }

    /*
     * Exception decompiling
     */
    private String[] queryMetaInfos(boolean isFunction) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private CallParameter parseFunctionReturnParam(String functionReturn) throws SQLException {
        if (functionReturn == null || functionReturn.length() == 0) {
            throw new SQLException(this.name + "is not a function returning value");
        }
        Matcher matcher = RETURN_PATTERN.matcher(functionReturn);
        if (!matcher.matches()) {
            throw new SQLException("can not parse return value definition :" + functionReturn);
        }
        CallParameter callParameter = new CallParameter();
        callParameter.setOutput(true);
        callParameter.setSigned(matcher.group(1) == null);
        callParameter.setTypeName(matcher.group(2).trim());
        callParameter.setSqlType(this.mapMariaDbTypeToJdbc(callParameter.getTypeName()));
        String scale = matcher.group(3);
        if (scale != null) {
            scale = scale.replace("(", "").replace(")", "").replace(" ", "");
            callParameter.setScale(Integer.valueOf(scale));
        }
        return callParameter;
    }

    private void parseParamList(boolean isFunction, String paramList) throws SQLException {
        int returnIndex;
        this.params = new ArrayList<CallParameter>();
        int index = 1;
        boolean i = false;
        if (isFunction && (returnIndex = paramList.indexOf("RETURNS")) != -1) {
            int bodyStartInedx = paramList.toUpperCase(Locale.ROOT).indexOf("BEGIN");
            String returnString = paramList.substring(returnIndex + "RETURNS".length(), bodyStartInedx);
            paramList = paramList.substring(0, returnIndex - 1);
            CallParameter parameterRetrurn = this.parseFunctionReturnParam(returnString);
            parameterRetrurn.setIndex(index++);
            this.params.add(parameterRetrurn);
        }
        Matcher matcher2 = PARAMETER_PATTERN.matcher(paramList);
        while (matcher2.find()) {
            CallParameter callParameter = new CallParameter();
            String direction = matcher2.group(1);
            if (direction != null) {
                direction = direction.trim();
            }
            callParameter.setName(matcher2.group(2).trim());
            callParameter.setSigned(matcher2.group(3) == null);
            callParameter.setTypeName(matcher2.group(4).trim().toUpperCase(Locale.ROOT));
            if (direction == null || direction.equalsIgnoreCase("IN")) {
                callParameter.setInput(true);
            } else if (direction.equalsIgnoreCase("OUT")) {
                callParameter.setOutput(true);
            } else if (direction.equalsIgnoreCase("INOUT")) {
                callParameter.setInput(true);
                callParameter.setOutput(true);
            } else {
                throw new SQLException("unknown parameter direction " + direction + "for " + callParameter.getName());
            }
            callParameter.setSqlType(this.mapMariaDbTypeToJdbc(callParameter.getTypeName()));
            String scale = matcher2.group(5);
            if (scale != null) {
                if ((scale = scale.trim().replace("(", "").replace(")", "").replace(" ", "")).contains(",")) {
                    scale = scale.substring(0, scale.indexOf(","));
                }
                callParameter.setScale(Integer.valueOf(scale));
            }
            this.params.add(callParameter);
            callParameter.setIndex(index++);
        }
    }

    private void readMetadata() throws SQLException {
        if (this.valid) {
            return;
        }
        String paramList = null;
        Object functionReturn = null;
        Object pstmt = null;
        ResultSet resultSet = null;
        if (this.isFunction) {
            resultSet = this.database != null ? this.con.createStatement().executeQuery("SHOW CREATE FUNCTION " + this.database + "." + this.name) : this.con.createStatement().executeQuery("SHOW CREATE FUNCTION " + this.name);
            resultSet.next();
            String procedureDDl = resultSet.getString("Create Function");
            paramList = procedureDDl.substring(procedureDDl.indexOf("(") - 1);
        } else {
            resultSet = this.database != null ? this.con.createStatement().executeQuery("SHOW CREATE PROCEDURE " + this.database + "." + this.name) : this.con.createStatement().executeQuery("SHOW CREATE PROCEDURE " + this.name);
            resultSet.next();
            String procedureDDl = resultSet.getString("Create Procedure");
            paramList = procedureDDl.substring(procedureDDl.indexOf("(") - 1);
        }
        this.parseParamList(this.isFunction, paramList);
    }

    @Override
    public int getParameterCount() {
        return this.params.size();
    }

    public CallParameter getParamByName(String name) {
        return null;
    }

    public CallParameter getParam(int index) throws SQLException {
        if (index < 1 || index > this.params.size()) {
            throw new SQLException("invalid parameter index " + index);
        }
        this.readMetadataFromDbIfRequired();
        return this.params.get(index - 1);
    }

    @Override
    public int isNullable(int param) throws SQLException {
        return this.getParam(param).getCanBeNull();
    }

    @Override
    public boolean isSigned(int param) throws SQLException {
        return this.getParam(param).isSigned();
    }

    @Override
    public int getPrecision(int param) throws SQLException {
        return this.getParam(param).getPrecision();
    }

    @Override
    public int getScale(int param) throws SQLException {
        return this.getParam(param).getScale();
    }

    @Override
    public int getParameterType(int param) throws SQLException {
        return this.getParam(param).getSqlType();
    }

    @Override
    public String getParameterTypeName(int param) throws SQLException {
        return this.getParam(param).getTypeName();
    }

    @Override
    public String getParameterClassName(int param) throws SQLException {
        return this.getParam(param).getClassName();
    }

    @Override
    public int getParameterMode(int param) throws SQLException {
        CallParameter callParameter = this.getParam(param);
        if (callParameter.isInput() && callParameter.isOutput()) {
            return 2;
        }
        if (callParameter.isInput()) {
            return 1;
        }
        if (callParameter.isOutput()) {
            return 4;
        }
        return 0;
    }

    public String getName(int param) throws SQLException {
        return this.getParam(param).getName();
    }

    @Override
    public <T> T unwrap(Class<T> iface) {
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) {
        return false;
    }
}

