/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.jdbc.extend.datatype;

import com.oceanbase.jdbc.extend.datatype.Datum;
import java.security.InvalidParameterException;
import java.sql.SQLException;

public class INTERVALYM
extends Datum {
    private static int MASKVAL = 255;
    private static int INTYMYEAROFFSET = Integer.MIN_VALUE;
    private static int INTYMMONTHOFFSET = 60;
    private static int INTERVALYMMAXLENGTH = 5;
    private static int MAXYEARPREC = 9;
    private static int MAXMONTH = 12;
    private static int INTERVALYM_BYTE_NUM = 7;

    public INTERVALYM() {
        super(INTERVALYM.toBytes("0-0"));
    }

    public INTERVALYM(byte[] bytes) {
        super(bytes);
    }

    public INTERVALYM(String str) {
        super(INTERVALYM.toBytes(str));
    }

    public static byte[] toBytes(String var) {
        if (var == null) {
            return null;
        }
        byte[] intervalymBytes = new byte[INTERVALYM_BYTE_NUM];
        String trimStr = var.trim();
        char ch = var.charAt(0);
        int is_negative = 0;
        int year = 0;
        int month = 0;
        int pos = 0;
        if (ch != '-' && ch != '+') {
            pos = 0;
        } else {
            pos = 1;
            if (ch == '-') {
                is_negative = 1;
            }
        }
        String subStr = trimStr.substring(pos);
        int index = subStr.indexOf(45);
        String yearStr = subStr.substring(0, index);
        if (yearStr.length() > MAXYEARPREC) {
            throw new NumberFormatException("invalid year " + yearStr + " in " + var);
        }
        String monthStr = subStr.substring(index + 1);
        year = Integer.valueOf(yearStr);
        month = Integer.valueOf(monthStr);
        if (month >= MAXMONTH) {
            throw new NumberFormatException("invalid month " + month + " in " + var);
        }
        intervalymBytes[0] = (byte)(is_negative & 0xFF);
        byte[] tmpBytes = INTERVALYM.intToBytes(year);
        System.arraycopy(tmpBytes, 0, intervalymBytes, 1, 4);
        intervalymBytes[5] = (byte)(month & 0xFF);
        intervalymBytes[6] = (byte)yearStr.length();
        return intervalymBytes;
    }

    public static String toString(byte[] data) {
        if (data != null && data.length != 0) {
            if (data.length != INTERVALYM_BYTE_NUM) {
                throw new InvalidParameterException("invalid len:" + data.length);
            }
            int is_negative = data[0] & MASKVAL;
            int year = INTERVALYM.getInt(data, 1);
            int month = data[5] & MASKVAL;
            int year_scale = data[6] & MASKVAL;
            if (year < 0 || (double)year > Math.pow(10.0, MAXYEARPREC)) {
                throw new NumberFormatException("year should not exceed " + Math.pow(10.0, MAXYEARPREC) + ", now is " + year);
            }
            if (month < 0 || month >= MAXMONTH) {
                throw new NumberFormatException("month should not exceed " + MAXMONTH + ", now is " + month);
            }
            String result = year_scale != 0 ? String.format("%" + year_scale + "d-%2d", year, month) : String.format("0-%2d", month);
            String[] s = result.split(" ");
            if (s.length > 1) {
                result = "";
                for (int i = 0; i < s.length; ++i) {
                    result = result + s[i];
                }
            }
            if (is_negative == 0) {
                return result;
            }
            return "-" + result;
        }
        return new String();
    }

    @Override
    public String stringValue() {
        return INTERVALYM.toString(this.getBytes());
    }

    @Override
    public boolean isConvertibleTo(Class targetClass) {
        return targetClass.getName().compareTo("java.lang.String") == 0;
    }

    @Override
    public Object toJdbc() throws SQLException {
        return this;
    }

    @Override
    public Object makeJdbcArray(int intVal) {
        INTERVALYM[] object = new INTERVALYM[intVal];
        return object;
    }

    public String toString() {
        return INTERVALYM.toString(this.getBytes());
    }
}

