/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.jdbc.extend.datatype;

import com.oceanbase.jdbc.extend.datatype.Datum;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

public class TIMESTAMP
extends Datum
implements Serializable {
    static final int[] daysInMonth = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    public static int SIZE_TIMESTAMP = 12;

    public TIMESTAMP() {
        super(TIMESTAMP.initTimestamp());
    }

    public TIMESTAMP(byte[] bytes) {
        super(bytes);
    }

    public TIMESTAMP(Time time) {
        super(TIMESTAMP.toBytes(time));
    }

    public TIMESTAMP(Date date) {
        super(TIMESTAMP.toBytes(date));
    }

    public TIMESTAMP(Timestamp timestamp) {
        super(TIMESTAMP.toBytes(timestamp));
    }

    public TIMESTAMP(Timestamp timestamp, Calendar calendar) {
        super(TIMESTAMP.toBytes(timestamp, calendar));
    }

    public static final int getNanos(byte[] bytes, int idx) {
        int nanos = (bytes[idx + 3] & 0xFF) << 24;
        nanos |= (bytes[idx + 2] & 0xFF) << 16;
        nanos |= (bytes[idx + 1] & 0xFF) << 8;
        return nanos |= bytes[idx] & 0xFF;
    }

    public static final void setNanos(byte[] bytes, int idx, int nanos) {
        bytes[idx + 3] = (byte)(nanos >> 24 & 0xFF);
        bytes[idx + 2] = (byte)(nanos >> 16 & 0xFF);
        bytes[idx + 1] = (byte)(nanos >> 8 & 0xFF);
        bytes[idx] = (byte)(nanos & 0xFF);
    }

    public TIMESTAMP(String str) {
        super(TIMESTAMP.toBytes(str));
    }

    public static Date toDate(byte[] bytes) throws SQLException {
        int i;
        int[] result = new int[SIZE_TIMESTAMP];
        for (i = 0; i < bytes.length; ++i) {
            result[i] = bytes[i] & 0xFF;
        }
        i = result[0] * 100 + result[1];
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, i);
        calendar.set(2, result[2] - 1);
        calendar.set(5, result[3]);
        calendar.set(11, result[4] - 1);
        calendar.set(12, result[5] - 1);
        calendar.set(13, result[6] - 1);
        calendar.set(14, 0);
        long time = calendar.getTime().getTime();
        return new Date(time);
    }

    public static Time toTime(byte[] bytes) throws SQLException {
        int hour = bytes[4] & 0xFF;
        int minute = bytes[5] & 0xFF;
        int second = bytes[6] & 0xFF;
        return new Time(hour, minute, second);
    }

    public static Timestamp toTimestamp(byte[] bytes) throws SQLException {
        return TIMESTAMP.innerToTimestamp(bytes, null);
    }

    private static Timestamp innerToTimestamp(byte[] bytes, Calendar cal) throws SQLException {
        int i;
        int[] result = new int[SIZE_TIMESTAMP];
        for (i = 0; i < bytes.length; ++i) {
            result[i] = bytes[i] & 0xFF;
        }
        i = result[0] * 100 + result[1];
        Calendar calendar = cal;
        if (null == calendar) {
            calendar = Calendar.getInstance();
        }
        calendar.set(1, i);
        calendar.set(2, result[2] - 1);
        calendar.set(5, result[3]);
        calendar.set(11, result[4]);
        calendar.set(12, result[5]);
        calendar.set(13, result[6]);
        calendar.set(14, 0);
        long time = calendar.getTime().getTime();
        Timestamp timestamp = new Timestamp(time);
        timestamp.setNanos(TIMESTAMP.getNanos(bytes, 7));
        return timestamp;
    }

    public static Timestamp toTimestamp(byte[] bytes, Calendar calendar) throws SQLException {
        return TIMESTAMP.innerToTimestamp(bytes, calendar);
    }

    @Override
    public Timestamp timestampValue() throws SQLException {
        return TIMESTAMP.toTimestamp(this.getBytes());
    }

    @Override
    public Timestamp timestampValue(Calendar calendar) throws SQLException {
        return TIMESTAMP.toTimestamp(this.getBytes(), calendar);
    }

    public static String toString(byte[] bytes) {
        int i;
        int[] buf = new int[bytes.length];
        for (i = 0; i < bytes.length; ++i) {
            buf[i] = bytes[i] & 0xFF;
        }
        i = buf[0] * 100 + buf[1];
        int month = buf[2];
        int day = buf[3];
        int hour = buf[4];
        int minute = buf[5];
        int second = buf[6];
        int nanos = TIMESTAMP.getNanos(bytes, 7);
        return TIMESTAMP.toString(i, month, day, hour, minute, second, nanos, bytes[11], null);
    }

    public static String toString(int year, int month, int day, int hour, int minute, int second, int nanos, int scale, String timezone) {
        String time = "" + year + "-" + TIMESTAMP.toStr(month) + "-" + TIMESTAMP.toStr(day) + " " + TIMESTAMP.toStr(hour) + ":" + TIMESTAMP.toStr(minute) + ":" + TIMESTAMP.toStr(second);
        if (nanos >= 0) {
            int index;
            String temp = String.format("%09d", nanos);
            char[] chars = temp.toCharArray();
            for (index = chars.length; index > 1 && chars[index - 1] == '0'; --index) {
            }
            if (scale > (temp = temp.substring(0, index)).length()) {
                int x = scale - temp.length();
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < x; ++i) {
                    sb.append("0");
                }
                temp = temp + sb.toString();
            }
            time = time + "." + temp;
        }
        if (timezone != null) {
            time = time + " " + timezone;
        }
        return time;
    }

    private static String toStr(int temp) {
        return temp < 10 ? "0" + temp : Integer.toString(temp);
    }

    public byte[] toBytes() {
        return this.getBytes();
    }

    public static byte[] toBytes(Time time) {
        if (time == null) {
            return null;
        }
        byte[] result = new byte[SIZE_TIMESTAMP];
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(time);
        result[0] = 19;
        result[1] = 70;
        result[2] = 1;
        result[3] = 1;
        result[4] = (byte)calendar.get(11);
        result[5] = (byte)calendar.get(12);
        result[6] = (byte)calendar.get(13);
        TIMESTAMP.setNanos(result, 7, 0);
        result[11] = 0;
        return result;
    }

    public static byte[] toBytes(Date date) {
        if (date == null) {
            return null;
        }
        byte[] result = new byte[SIZE_TIMESTAMP];
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        result[0] = (byte)(calendar.get(1) / 100);
        result[1] = (byte)(calendar.get(1) % 100);
        result[2] = (byte)(calendar.get(2) + 1);
        result[3] = (byte)calendar.get(5);
        result[4] = 0;
        result[5] = 0;
        result[6] = 0;
        TIMESTAMP.setNanos(result, 7, 0);
        result[11] = 0;
        return result;
    }

    public static byte[] toBytes(Timestamp timestamp) {
        if (timestamp == null) {
            return null;
        }
        int nanos = timestamp.getNanos();
        byte[] result = new byte[SIZE_TIMESTAMP];
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(timestamp);
        result[0] = (byte)(calendar.get(1) / 100);
        result[1] = (byte)(calendar.get(1) % 100);
        result[2] = (byte)(calendar.get(2) + 1);
        result[3] = (byte)calendar.get(5);
        result[4] = (byte)calendar.get(11);
        result[5] = (byte)calendar.get(12);
        result[6] = (byte)calendar.get(13);
        TIMESTAMP.setNanos(result, 7, nanos);
        return result;
    }

    public static byte[] toBytes(Timestamp timestamp, Calendar calendar) {
        if (timestamp == null) {
            return null;
        }
        int nanos = timestamp.getNanos();
        byte[] result = new byte[SIZE_TIMESTAMP];
        if (calendar == null) {
            calendar = Calendar.getInstance();
        }
        calendar.clear();
        calendar.setTime(timestamp);
        int year = calendar.get(1);
        if (calendar.get(0) == 0) {
            year = -(year - 1);
        }
        if (year >= -4712 && year <= 9999) {
            result[0] = (byte)(year / 100);
            result[1] = (byte)(year % 100);
            result[2] = (byte)(calendar.get(2) + 1);
            result[3] = (byte)calendar.get(5);
            result[4] = (byte)calendar.get(11);
            result[5] = (byte)calendar.get(12);
            result[6] = (byte)calendar.get(13);
            TIMESTAMP.setNanos(result, 7, nanos);
            return result;
        }
        throw new IllegalArgumentException("Invalid year value");
    }

    public static byte[] toBytes(String str) {
        return TIMESTAMP.toBytes(Timestamp.valueOf(str));
    }

    @Override
    public Object toJdbc() throws SQLException {
        return this.timestampValue();
    }

    @Override
    public Object makeJdbcArray(int len) {
        Timestamp[] timestamps = new Timestamp[len];
        return timestamps;
    }

    @Override
    public boolean isConvertibleTo(Class clazz) {
        return clazz.getName().compareTo("java.sql.Date") == 0 || clazz.getName().compareTo("java.sql.Time") == 0 || clazz.getName().compareTo("java.sql.Timestamp") == 0 || clazz.getName().compareTo("java.lang.String") == 0;
    }

    @Override
    public String stringValue() {
        return TIMESTAMP.toString(this.getBytes());
    }

    public String toString() {
        return this.stringValue();
    }

    @Override
    public Date dateValue() throws SQLException {
        return TIMESTAMP.toDate(this.getBytes());
    }

    @Override
    public Time timeValue() throws SQLException {
        return TIMESTAMP.toTime(this.getBytes());
    }

    private static byte[] initTimestamp() {
        byte[] bytes = new byte[SIZE_TIMESTAMP];
        bytes[0] = 19;
        bytes[1] = 70;
        bytes[2] = 1;
        bytes[3] = 1;
        bytes[4] = 0;
        bytes[5] = 0;
        bytes[6] = 0;
        TIMESTAMP.setNanos(bytes, 7, 0);
        bytes[11] = 0;
        return bytes;
    }

    private boolean isLeapYear(int time) {
        if (time % 4 != 0 || !(time <= 1582 ? time != -4712 : time % 100 != 0 || time % 400 == 0)) {
            boolean isLeapYear = false;
            return isLeapYear;
        }
        boolean isLeapYear = true;
        return isLeapYear;
    }

    private boolean isValid() {
        byte[] bytes = this.getBytes();
        if (bytes.length < SIZE_TIMESTAMP) {
            return false;
        }
        int year = (bytes[0] & 0xFF) * 100 + (bytes[1] & 0xFF);
        if (year >= -4712 && year <= 9999) {
            if (year == 0) {
                return false;
            }
            int month = bytes[2] & 0xFF;
            if (month >= 1 && month <= 12) {
                int day = bytes[3] & 0xFF;
                if (day >= 1 && day <= 31) {
                    if (!(day <= daysInMonth[month - 1] || this.isLeapYear(year) && month == 2 && day == 29)) {
                        return false;
                    }
                    if (year == 1582 && month == 10 && day >= 5 && day < 15) {
                        return false;
                    }
                    int hour = bytes[4] & 0xFF;
                    if (hour >= 1 && hour <= 24) {
                        int second = bytes[5] & 0xFF;
                        if (second >= 1 && second <= 60) {
                            int temp = bytes[6] & 0xFF;
                            return temp >= 1 && temp <= 60;
                        }
                        return false;
                    }
                    return false;
                }
                return false;
            }
            return false;
        }
        return false;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        if (!this.isValid()) {
            throw new IOException("Invalid TIMESTAMP");
        }
    }
}

