/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.jdbc.internal.com.send;

import com.oceanbase.jdbc.internal.ColumnType;
import com.oceanbase.jdbc.internal.com.read.Buffer;
import com.oceanbase.jdbc.internal.com.read.dao.Results;
import com.oceanbase.jdbc.internal.com.read.resultset.ColumnDefinition;
import com.oceanbase.jdbc.internal.com.send.parameters.OBArrayParameter;
import com.oceanbase.jdbc.internal.com.send.parameters.OBStringParameter;
import com.oceanbase.jdbc.internal.com.send.parameters.OBStructParameter;
import com.oceanbase.jdbc.internal.com.send.parameters.ParameterHolder;
import com.oceanbase.jdbc.internal.io.input.PacketInputStream;
import com.oceanbase.jdbc.internal.io.output.PacketOutputStream;
import com.oceanbase.jdbc.internal.protocol.Protocol;
import com.oceanbase.jdbc.internal.util.dao.ServerPrepareResult;
import java.io.IOException;
import java.sql.SQLException;

public class ComStmtPrepareExecute {
    public static void send(PacketOutputStream pos, Results results, int parameterCount, ParameterHolder[] parameters, ColumnType[] parameterTypeHeader, byte cursorFlag, Protocol protocol, ServerPrepareResult serverPrepareResult) throws IOException, SQLException {
        pos.startPacket(0);
        pos.write(-95);
        if (serverPrepareResult == null) {
            pos.writeInt(results.getStatementId());
        } else {
            pos.writeInt(serverPrepareResult.getStatementId());
        }
        pos.write(cursorFlag);
        pos.writeInt(protocol.getIterationCount());
        OBStringParameter lengthEncodedString = new OBStringParameter(results.getStatement().getActualSql(), protocol.noBackslashEscapes(), protocol.getOptions().characterEncoding);
        lengthEncodedString.writeBinary(pos);
        pos.writeInt(parameterCount);
        if (parameterCount > 0) {
            int i;
            int nullCount = (parameterCount + 7) / 8;
            byte[] nullBitsBuffer = new byte[nullCount];
            for (int i2 = 0; i2 < parameterCount; ++i2) {
                if (!parameters[i2].isNullData()) continue;
                int n = i2 / 8;
                nullBitsBuffer[n] = (byte)(nullBitsBuffer[n] | 1 << i2 % 8);
            }
            pos.write(nullBitsBuffer, 0, nullCount);
            boolean mustSendHeaderType = false;
            if (parameterTypeHeader == null || parameterTypeHeader[0] == null) {
                mustSendHeaderType = true;
            } else {
                for (i = 0; i < parameterCount; ++i) {
                    if (parameterTypeHeader[i].equals((Object)parameters[i].getColumnType())) continue;
                    mustSendHeaderType = true;
                    break;
                }
            }
            pos.write((byte)(mustSendHeaderType ? 1 : 0));
            if (mustSendHeaderType) {
                for (i = 0; i < parameterCount; ++i) {
                    if (parameterTypeHeader == null) {
                        pos.writeShort(parameters[i].getColumnType().getType());
                    } else {
                        parameterTypeHeader[i] = parameters[i].getColumnType();
                        pos.writeShort(parameterTypeHeader[i].getType());
                    }
                    if (parameters[i].getColumnType().getType() != ColumnType.COMPLEX.getType()) continue;
                    ParameterHolder obj = parameters[i];
                    if (obj instanceof OBArrayParameter) {
                        ((OBArrayParameter)obj).storeArrayTypeInfo(pos);
                        continue;
                    }
                    if (obj instanceof OBStructParameter) {
                        ((OBStructParameter)obj).storeStructTypeInfo(pos);
                        continue;
                    }
                    throw new SQLException("complex param type is not supported\uff0c only array is supported");
                }
            }
            for (i = 0; i < parameterCount; ++i) {
                ParameterHolder holder = parameters[i];
                if (holder.isNullData() || holder.isLongData()) continue;
                holder.writeBinary(pos);
            }
        }
        pos.writeInt(protocol.getExecuteMode());
        pos.writeInt(0);
        pos.writeInt((int)protocol.getChecksum());
        pos.writeInt(0);
        pos.flush();
    }

    public static ServerPrepareResult read(Protocol protocol, PacketInputStream reader, ServerPrepareResult serverPrepareResult, Results results) throws IOException, SQLException {
        boolean eofDeprecated = protocol.isEofDeprecated();
        Buffer buffer = reader.getPacket(true);
        byte firstByte = buffer.getByteAt(0);
        switch (firstByte) {
            case 0: {
                buffer.skipByte();
                int statementId = buffer.readInt();
                results.setStatementId(statementId);
                int numColumns = buffer.readShort() & 0xFFFF;
                int numParams = buffer.readIntV1();
                byte reserved1 = buffer.readByte();
                short warningCount = buffer.readShort();
                int extendFlag = buffer.readInt();
                byte hasResultSet = buffer.readByte();
                ColumnDefinition[] params = new ColumnDefinition[numParams];
                if (numParams > 0) {
                    for (int i = 0; i < numParams; ++i) {
                        params[i] = new ColumnDefinition(reader.getPacket(false), true, protocol.getOptions().characterEncoding);
                    }
                    if (!eofDeprecated) {
                        protocol.skipEofPacket();
                    }
                }
                ColumnDefinition[] columns = new ColumnDefinition[numColumns];
                if (hasResultSet == 1) {
                    protocol.readResultSet(columns, results);
                }
                buffer = reader.getPacket(true);
                switch (buffer.getByteAt(0)) {
                    case 0: {
                        protocol.readOkPacket(buffer, results);
                        break;
                    }
                    case -1: {
                        throw protocol.readErrorPacket(buffer, results);
                    }
                }
                return serverPrepareResult != null ? serverPrepareResult : new ServerPrepareResult(results.getSql(), statementId, columns, params, protocol);
            }
            case -1: {
                throw protocol.readErrorPacket(buffer, results);
            }
        }
        throw new SQLException("Unexpected packet returned by server, first byte " + firstByte);
    }

    public static void readTailPacket(Protocol protocol, PacketInputStream reader, Results results, boolean hasResultSet) throws IOException, SQLException {
        Buffer buffer = reader.getPacket(true);
        switch (buffer.getByteAt(0)) {
            case 0: {
                if (hasResultSet) break;
                protocol.readOkPacket(buffer, results);
                break;
            }
            case -1: {
                throw protocol.readErrorPacket(buffer, results);
            }
        }
    }
}

