/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.jdbc.internal.failover.BlackList.append;

import com.oceanbase.jdbc.HostAddress;
import com.oceanbase.jdbc.internal.failover.BlackList.append.AppendStrategy;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class RetryDuration
implements AppendStrategy {
    private long duration;
    private int retryTimes;
    private static ConcurrentMap<HostAddress, List<Long>> failureRecords = new ConcurrentHashMap<HostAddress, List<Long>>();
    private static long maxDuration;

    public RetryDuration(long duration, int retryTimes) {
        this.duration = duration;
        this.retryTimes = retryTimes;
    }

    public String toString() {
        return "RetryDuration{}";
    }

    @Override
    public boolean needToAppend(HostAddress host, Properties properties) {
        boolean need;
        long failedTime = Long.parseLong((String)properties.get("failedTime"));
        if (!failureRecords.containsKey(host)) {
            failureRecords.put(host, new ArrayList());
        }
        List recentFailedTimeList = (List)failureRecords.get(host);
        recentFailedTimeList.add(failedTime);
        int count = 0;
        Iterator it_b = recentFailedTimeList.iterator();
        while (it_b.hasNext()) {
            long ts = (Long)it_b.next();
            if (failedTime - ts > maxDuration * 1000L) {
                it_b.remove();
                continue;
            }
            if (failedTime - ts > this.duration * 1000L) continue;
            ++count;
        }
        boolean bl = need = count >= this.retryTimes;
        if (need) {
            RetryDuration.removeFromFailureRecords(host);
        }
        return need;
    }

    public static void removeFromFailureRecords(HostAddress host) {
        if (host != null) {
            failureRecords.remove(host);
        }
    }

    public static void updateMaxDuration(long newDuration) {
        maxDuration = Math.max(newDuration, maxDuration);
    }
}

